/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.vpd;

import com.ibm.hwmca.base.util.BaseFileControl;
import com.ibm.hwmca.base.util.BaseMessageText;
import com.ibm.hwmca.base.util.BaseMessageTitle;
import com.ibm.hwmca.base.util.BaseTextBundle;
import com.ibm.hwmca.base.vpd.TransmitVpdBean;
import com.ibm.hwmca.base.vpd.VpdErrorIds;
import com.ibm.hwmca.base.vpd.VpdTasks;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.FrameworkEventText;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.log.SystemEventLog;
import com.ibm.hwmca.fw.msgpanel.CommonMsgInterface;
import com.ibm.hwmca.fw.rsf.RemoteSupportFacility;
import com.ibm.hwmca.fw.rsf.RsfManager;
import com.ibm.hwmca.fw.task.HwmcaPanelTasklet;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.tasklet.PanelTaskletResponse;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.MessageText;
import com.ibm.hwmca.fw.util.Trace;

public class TransmitVpdTasklet
extends HwmcaPanelTasklet
implements VpdErrorIds,
CommonMsgInterface {
    private static final String TRACE_MASKT = "HCONTVTT";
    private static final String TRACE_MASKF = "HCONTVTF";
    private static final String TRACE_MASKD = "HCONTVTD";
    private static final String AUIML_FILE_NAME = "com.ibm.hwmca.base.vpd.res.TransmitVpdRes";
    private static final String PANEL_NAME = "TransmitVpdPanel";
    private TransmitVpdBean bean;

    public TransmitVpdTasklet() {
        Trace.trace(TRACE_MASKT, "<> TransmitVpdTasklet ctor");
    }

    public void service(PanelTaskletRequest taskletRequest, PanelTaskletResponse taskletResponse) throws TaskletException {
        block16: {
            FrameworkEventText frameworkEventText = new FrameworkEventText(84);
            BaseMessageTitle title = new BaseMessageTitle("TVPD8001");
            MessageText[] messageText = new BaseMessageText[1];
            boolean keepPanelUp = false;
            Trace.trace(TRACE_MASKT, "-> TransmitVpdTasklet.service()");
            try {
                if (taskletRequest.isInitialRequest()) {
                    this.bean = new TransmitVpdBean();
                    RemoteSupportFacility rsf = RsfManager.getRsfManager().getConsoleRsf();
                    this.bean.setRsfEnabled(rsf != null && rsf.isCallHomeEnabled() && rsf.isCallHomeServerAvailable());
                    taskletResponse.replace(AUIML_FILE_NAME, PANEL_NAME, this.bean);
                    break block16;
                }
                if (taskletRequest.isDisposed() || taskletRequest.isCanceled()) {
                    taskletResponse.terminate();
                    break block16;
                }
                String action = (String)taskletRequest.getData("action");
                Trace.trace(TRACE_MASKF, "TransmitVpdTasklet.service client requested action is: " + action);
                if (action.equals("transmit")) {
                    String destination = (String)taskletRequest.getData("destination");
                    this.showBusyDialog(new LocalizableText(BaseTextBundle.getBundleName(), "vpd.transmit.busy.title"), new LocalizableText(BaseTextBundle.getBundleName(), "vpd.transmit.busy2.text"));
                    try {
                        VpdTasks vpdTasks = new VpdTasks();
                        vpdTasks.createHmca();
                        Trace.trace(TRACE_MASKF, "TransmitVpdTasklet.service about to perform Transmit VPD operation");
                        if (destination.equals("RetainItem")) {
                            Trace.trace(TRACE_MASKF, "TransmitVpdTasklet.service Destination selection is Retain");
                            frameworkEventText = new FrameworkEventText(84);
                            vpdTasks.transmitHmcaToRetain();
                        } else if (destination.equals("DisketteItem")) {
                            Trace.trace(TRACE_MASKF, "TransmitVpdTasklet.service Destination selection is Diskette");
                            frameworkEventText = new FrameworkEventText(664);
                            keepPanelUp = vpdTasks.transmitToDiskette(this, BaseFileControl.getFilePath("actvhmca.dat") + "actvhmca.dat", "actvhmca.dat", 1);
                        } else if (destination.equals("HardDriveItem")) {
                            Trace.trace(TRACE_MASKF, "TransmitVpdTasklet.service Destination selection is Hard Drive");
                            frameworkEventText = new FrameworkEventText(665);
                        }
                        if (!keepPanelUp) {
                            String eventName = "CONHONE";
                            SystemEventLog systemEventLog = new SystemEventLog(frameworkEventText, eventName);
                            systemEventLog.log();
                            Trace.trace(TRACE_MASKF, "Display message 'Transmit VPD successful Completion'");
                            messageText[0] = destination.equals("RetainItem") ? new BaseMessageText("TVPDXMIT") : new BaseMessageText("TVPDGOOD");
                        }
                    }
                    catch (HException hexc) {
                        Trace.trace(TRACE_MASKF, "Display message 'Transmit VPD failed'");
                        messageText[0] = new BaseMessageText("TVPDPROB");
                    }
                    this.destroyBusyDialog();
                    if (!keepPanelUp) {
                        LocalizableText[] msgOptions = new LocalizableText[]{CommonMsgInterface.OK_BUTTON};
                        this.showMessageBox(true, title, messageText, messageText[0].getMsgId(), messageText[0].getMsgType(), msgOptions);
                        taskletResponse.terminate();
                    } else {
                        taskletResponse.noAction();
                    }
                    break block16;
                }
                taskletResponse.terminate();
            }
            catch (Exception e) {
                Trace.trace(TRACE_MASKF, "Exception during TransmitVpdTasklet.service: ");
                Trace.trace(TRACE_MASKF, e);
                new FrameworkLog(VpdErrorIds.TRANSMITVPD_LOGINFO, 30723, e).log();
                if (e instanceof TaskletException) {
                    throw (TaskletException)e;
                }
                throw new TaskletException(e);
            }
        }
        Trace.trace(TRACE_MASKT, "<- TransmitVpdTasklet.service()");
    }

    public void logException(Throwable throwable) {
        Trace.trace(TRACE_MASKT, "-> TransmitVpdTasklet.logException()");
        new FrameworkLog(VpdErrorIds.TRANSMITVPD_LOGINFO, 30722, throwable).log();
        Trace.trace(TRACE_MASKT, "<- TransmitVpdTasklet.logException()");
    }
}

